



<html>
<head>
  <title>javabog.dk - Webprogrammering med Java Server Pages - Java Server Faces</title>
  <link rev="stylesheet" type="text/css" href="../typografi.css">
  <meta name="description" content="Lrebog i Java. Af Jacob Nordfalk. Udkommet hos Forlaget Globe">
  <meta name="keywords" content="designmnster, programmering, OOP, objekter, klasser, objektorienteret programmering, Java, JSP, lrebog, UML, IT">
</head>
<body bgcolor="#ffffff">



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel14.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;n&aelig;ste &gt;&gt;&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_JSP.html'>om bogen</a>

<H1 CLASS="western" ALIGN=LEFT STYLE="">15 <a name='afsn15'></a>Java
Server Faces</H1>
<DIV ID="Indholdsfortegnelse15">
  <P STYLE="margin-top: 0.5cm; margin-bottom: 0cm"><BR>
  </P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>15.1
  Kernefunktionalitet (&lt;f: &gt;)  289</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>15.2
  HTML-funktionalitet (&lt;h: &gt;)  289</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>15.3
  Visning af g&aelig;stebog fra JSF  290</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>15.4
  Opdatering af g&aelig;stebog fra JSF  292</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">15.4.1
  Avanceret: Validatorer  293</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">15.4.2
  Avanceret: Fejlmeddelelser  293</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">15.4.3
  Avanceret: Resursebundter  293</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">15.4.4
  At gemme data i en javab&oslash;nne  294</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">15.4.5
  Avanceret: Startv&aelig;rdier for egenskaber  294</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>15.5
  Afl&aelig;sning af JSF-b&oslash;nnes egenskab  295</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">15.5.1
  Adgang til de implicitte objekter fra JSF  295</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>15.6
  JSF - anbefalet praksis  296</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">15.6.1
  At gemme midlertidige data i en HashMap  296</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>15.7
  Resum&eacute;  298</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">15.7.1
  JSF og JDeveloper  298</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">15.7.2
  M&aring;der at aktivere JSF-komponenter  298</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>15.8
  Kilder til JSF-komponenter  299</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">15.8.1
  Oracle ADF Faces  299</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">15.8.2
  Apache MyFaces  299</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">15.8.3
  Andre kilder  300</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>15.9
  EL - Expression Language  300</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>15.10
  Om associative tabeller (HashMap)  300</B></FONT></FONT></P>
</DIV>

<P CLASS="kapiteloversigt-western" STYLE="font-weight: medium; text-decoration: none">
Dette kapitel er frivillig l&aelig;sning; det foruds&aelig;ttes ikke
i resten af bogen. 
</P>

<P CLASS="western" STYLE="">Blablabla</P>
<P CLASS="western">xxx JSF er et HTML-lignende sprog, som man kan
skrive koden, der udf&oslash;res p&aring; serveren i, i stedet for
Java. For ikke-Java-kyndige HTML-designere skulle JSTL v&aelig;re
betydeligt simplere at bruge end Java, da syntaksen ligner den, de i
forvejen kender fra HTML<A CLASS="sdfootnoteanc" NAME="sdfootnote1anc" HREF="#sdfootnote1sym"><SUP>1</SUP></A>.</P>

<P CLASS="western">JSF fungerer i praksis som to tag-biblioteker
(eng.: taglibs). Det vis sige at JSP-sider der bruger JSF-komponenter
skal have linjerne</P>
<PRE CLASS="kode-western">&lt;%@ taglib uri=&quot;http://java.sun.com/jsf/core&quot; prefix=&quot;f&quot; %&gt;
&lt;%@ taglib uri=&quot;http://java.sun.com/jsf/html&quot; prefix=&quot;h&quot; %&gt;</PRE><P CLASS="western">
i starten af siden.</P>
<P CLASS="western">Et tag library (forkortet taglib) er, som navnet
siger, et bibliotek af HTML-lignende koder. Ligesom JSP-koderne
udf&oslash;res taglib-koderne p&aring; serveren.</P>

<H4 CLASS="western">L&aelig;sning om JSF</H4>
<UL>
  <LI><P CLASS="western">Officiel side p&aring; Sun:
  <A CLASS="western" HREF="http://java.sun.com/j2ee/javaserverfaces/">http://java.sun.com/j2ee/javaserverfaces/</A>
    </P>
  <LI><P CLASS="western"><A CLASS="western" HREF="http://jsftutorials.net/">http://jsftutorials.net</A>
    </P>
  <LI><P CLASS="western">Om JSF og JDeveloper:
  <A CLASS="western" HREF="http://www.oracle.com/technology/products/jdev/jsf.html">http://www.oracle.com/technology/products/jdev/jsf.html</A></P>
</UL>

<H2 CLASS="western">15.1 <a name='afsn15.1'></a>Kernefunktionalitet (&lt;f: &gt;)</SPAN></H2>
<P CLASS="western">Kernefunktioner (de mest basale funktioner) i JSF
ligger i core-taglibbet under navnet 'f'. Her er underst&oslash;ttelse
for h&aelig;ndelser, datakonvertering, lokalisering, validatorer og
andre ting. 
</P>
<P CLASS="western"><SPAN LANG="da-DK">Alle JSF-koder </SPAN>skal
f.eks. v&aelig;re indeholdt i et 'view', der s&oslash;rger for at
registrere og konfigurere JSF-komponenterne:</P>
<PRE CLASS="kode-western">&lt;f:view&gt;
  ... JSF-koder (og eventuelt andre JSP-koder)
&lt;/f:view&gt;</PRE><P CLASS="western">
De andre &lt;f:&gt;-koder ang&aring;r alle kernefunktionalitet i JSF:</P>
<P CLASS="western">xxx oversigstabel ind</P>

<H2 CLASS="western">15.2 <a name='afsn15.2'></a>HTML-funktionalitet (&lt;h: &gt;)</SPAN></H2>
<P CLASS="western"><SPAN LANG="da-DK">JSF er beregnet til at kunne
generere mange former for output (det mest almindelige er
selvf&oslash;lgelig HTML). Til dette bruges et JSF 'render kit', der
er et tagbibliotek med komponenter beregnet til den p&aring;g&aelig;ldende
form for output, f.eks. </SPAN>JSFs HTML-tagbibliotek &lt;h:&gt;:</P>
<P CLASS="western">xxx oversigstabel ind</P>


<H2 CLASS="western">15.3 <a name='afsn15.3'></a>Visning af g&aelig;stebog fra JSF</SPAN></H2>
<P CLASS="western">Herunder ses hvordan man kunne lave g&aelig;stebogen
vi s&aring; i databasekapitlet i afsnit xxx med JSF.</P>
<P CLASS="western">Bind et objekt (en javab&oslash;nne), til
applikationen, med f&oslash;lgende i faces-config.xml:</P>
<PRE CLASS="kode-western">  &lt;managed-bean&gt;
    &lt;managed-bean-name&gt;gaestebog&lt;/managed-bean-name&gt;
    &lt;managed-bean-class&gt;jsf.Gaestebog&lt;/managed-bean-class&gt;
    &lt;managed-bean-scope&gt;application&lt;/managed-bean-scope&gt;
  &lt;/managed-bean&gt;</PRE><P CLASS="western">
I JDeveloper (og sikkert ogs&aring; andre v&aelig;rkt&oslash;jer) kan
det g&oslash;res ved at g&aring; hen p&aring; fanen 'Overview' p&aring;
faces-config.xml:</P>
<P CLASS="western"><IMG SRC="bog16_html_2849af31.png" NAME="Grafik51" ALIGN=BOTTOM BORDER=0></P>

<P CLASS="western">Denne klasse har logikken til at hente et
ResultSet med data, med metoden getGaester():</P>
<PRE CLASS="kode-western">package jsf;
import java.sql.*;

public class Gaestebog
{
  private Connection con;
  
  public Gaestebog()
  {
    try {
      // Initialisering g&aelig;stebogen
      Class.forName(&quot;com.mysql.jdbc.Driver&quot;);
      con = DriverManager.getConnection(&quot;jdbc:mysql:///test&quot;);
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  public ResultSet getGaester()
  {
    System.out.println(&quot;inde i getGaester()&quot;);
    try {
<I>      // Hent ResultSet med g&aelig;stebogen</I>
      Statement stmt = con.createStatement();
     ResultSet rs = stmt.executeQuery(&quot;SELECT navn, besked, dato FROM gaestebog&quot;);
      return rs;
    } catch (Exception e) {
      e.printStackTrace();
      return null;
    }
  }
}</PRE>
<P CLASS="western">Nu kan vi lave en JSF-side med en &lt;h:dataTable
/&gt;, der viser g&aelig;sterne. V&aelig;rkt&oslash;jet sp&oslash;rger
os om hvilken v&aelig;rdi der skal vises (det er
#{gaestebog.gaester}, dvs metoden getGaester() p&aring;
Gaestebog-objektet, der jo giver ResultSet-objektet) og om navnet p&aring;
en variabel, der skal genneml&oslash;be alle r&aelig;kkerne.</P>
<P CLASS="western"><IMG SRC="bog16_html_m202b2d4.png" NAME="Grafik63" ALIGN=BOTTOM BORDER=0></P>
<P CLASS="western">Dern&aelig;st skal vi beskrive hvad der skal vises
i hver kolonne. Da vi har kaldt vores genneml&oslash;bsvariabel for
'g' er det den vi skal bruge. Da kolonnerne i databasen hedder hhv
'navn', 'dato' og 'besked' skriver vi hhv #{g.navn}, #{g.dato} og
#{g.besked} (egentlig bliver det oversat til getString(&quot;navn&quot;),
getString(&quot;dato&quot;) og getString(&quot;besked&quot;) p&aring;
ResultSet'et):  
</P>
<P CLASS="western"><IMG SRC="bog16_html_32a5dba4.png" NAME="Grafik102" ALIGN=BOTTOM BORDER=0></P>

<P CLASS="western">Herefter ser siden nogenlunde s&aring;dan her ud:</P>
<PRE CLASS="kode-western">&lt;%@ taglib uri=&quot;http://java.sun.com/jsf/core&quot; prefix=&quot;f&quot;%&gt;
&lt;%@ taglib uri=&quot;http://java.sun.com/jsf/html&quot; prefix=&quot;h&quot;%&gt;
&lt;f:view&gt;
  &lt;html&gt;
    &lt;head&gt;&lt;title&gt;G&aelig;stebog JSF&lt;/title&gt;&lt;/head&gt;
    &lt;body&gt;
      &lt;h:form&gt;
        &lt;h1&gt;G&aelig;stebog-jsf&lt;/h1&gt;
        &lt;p&gt;Velkommen til min lille g&aelig;stebog.&lt;/p&gt;
        &lt;p&gt;
          &lt;h:dataTable value=&quot;#{gaestebog.gaester}&quot; var=&quot;g&quot;&gt;
            &lt;h:column&gt;
              &lt;f:facet name=&quot;header&quot;&gt;
                &lt;h:outputText value=&quot;navn&quot;/&gt;
              &lt;/f:facet&gt;
              &lt;h:outputText value=&quot;#{g.navn}&quot;/&gt;
            &lt;/h:column&gt;
            &lt;h:column&gt;
              &lt;f:facet name=&quot;header&quot;&gt;
                &lt;h:outputText value=&quot;datoen&quot;/&gt;
              &lt;/f:facet&gt;
              &lt;h:outputText value=&quot;#{g.dato}&quot;/&gt;
            &lt;/h:column&gt;
            &lt;h:column&gt;
              &lt;f:facet name=&quot;header&quot;&gt;
                &lt;h:outputText value=&quot;beskedden&quot;/&gt;
              &lt;/f:facet&gt;
              &lt;h:outputLink&gt;
                &lt;h:outputText value=&quot;#{g.besked}&quot;/&gt;
              &lt;/h:outputLink&gt;
            &lt;/h:column&gt;
            &lt;h:column/&gt;
          &lt;/h:dataTable&gt;
        &lt;/p&gt;

        &lt;p&gt;
          Du kan skrive dig ind 
          &lt;h:commandLink action=&quot;indskriv&quot;&gt;
            &lt;h:outputText value=&quot;her&quot;/&gt;
          &lt;/h:commandLink&gt;
        &lt;/p&gt;
      &lt;/h:form&gt;

&lt;% 
<I>  // Her ses hvordan man f&aring;r fat i en JSF-b&oslash;nne fra almindelig JSP-kode</I>
  int antalG&aelig;ster = 0;
  jsf.Gaestebog g&aelig;stebog = (jsf.Gaestebog) application.getAttribute(&quot;gaestebog&quot;);
  java.sql.ResultSet rs = g&aelig;stebog.getGaester();
  while (rs.next()) antalG&aelig;ster++; <I>// t&aelig;l antal r&aelig;kker</I>
  out.print(&quot;&lt;p&gt;Der er i alt &quot;+antalG&aelig;ster+&quot; bes&oslash;g.&lt;/p&gt;&quot;);
%&gt;
    &lt;/body&gt;
  &lt;/html&gt;
&lt;/f:view&gt;</PRE><P CLASS="western">
<IMG SRC="bog16_html_m2c750571.png" NAME="Grafik103" ALIGN=BOTTOM BORDER=0></P>
<P CLASS="western">Nederst ses hvordan man kan f&aring; fat i JSFs
objekter fra almindelig JSP-kode:</P>
<PRE CLASS="kode-western">  jsf.Gaestebog g&aelig;stebog = (jsf.Gaestebog) application.getAttribute(&quot;gaestebog&quot;);</PRE><P CLASS="western">
Sammenlign med faces-config.xml, der erkl&aelig;rede at b&oslash;nnenavnet
var 'gaestebog' med virkefelt application af type ' jsf.Gaestebog'.</P>
<H2 CLASS="western">15.4 <a name='afsn15.4'></a>Opdatering af g&aelig;stebog fra JSF</SPAN></H2>
<P CLASS="western">Lad os nu lave en JSF-side, der opdaterer
g&aelig;stebogen:</P>
<PRE CLASS="kode-western">&lt;%@ taglib uri=&quot;http://java.sun.com/jsf/core&quot; prefix=&quot;f&quot;%&gt;
&lt;%@ taglib uri=&quot;http://java.sun.com/jsf/html&quot; prefix=&quot;h&quot;%&gt;
&lt;f:view&gt;
  &lt;html&gt;&lt;head&gt;&lt;title&gt;G&aelig;stebog - indskriv&lt;/title&gt;&lt;/head&gt;
    &lt;body&gt;
      &lt;h:form&gt;
        &lt;h:commandLink action=&quot;tilbage&quot;&gt;
          &lt;h:outputText value=&quot;tilbage til g&aelig;stebog&quot;/&gt;
        &lt;/h:commandLink&gt;
        
        &lt;h1&gt;Skriv dig ind i min g&aelig;stebog&lt;/h1&gt;
        &lt;p&gt;
            Navn: &lt;h:inputText value=&quot;#{gaest.navnet}&quot; /&gt;
        &lt;/p&gt;
        &lt;p&gt;
          Besked:&lt;br&gt;&lt;/br&gt;
        &lt;h:inputTextarea value=&quot;#{gaest.besked}&quot; cols=&quot;70&quot; rows=&quot;5&quot; /&gt;
        &lt;/p&gt;
        &lt;p&gt;
          &lt;h:commandButton value=&quot;Ok&quot; action=&quot;#{gaestebog.indskriv}&quot;/&gt;
        &lt;/p&gt;
      &lt;/h:form&gt;
    &lt;/body&gt;
  &lt;/html&gt;
&lt;/f:view&gt;</PRE><P CLASS="western">
xxx sk&aelig;rmbillede ind</P>
<P CLASS="western">Her har vi sat de to JSF-komponenter
&lt;h:inputText/&gt; og &lt;h:inputTextarea/&gt; til at binde til
egenskaberne hhv 'navnet' og 'besked' p&aring; javab&oslash;nnen
'gaest', der styres af JSF. 
</P>

<H3 CLASS="western">15.4.1 <a name='afsn15.4.1'></a>Avanceret: Validatorer</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel15.jsp#afsn15.4.1">
  <input type='checkbox' name='vis' value='15.4.1'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='15.4.1'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">15.4.2 <a name='afsn15.4.2'></a>Avanceret: Fejlmeddelelser</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel15.jsp#afsn15.4.2">
  <input type='checkbox' name='vis' value='15.4.2'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='15.4.2'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">15.4.3 <a name='afsn15.4.3'></a>Avanceret: Resursebundter</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel15.jsp#afsn15.4.3">
  <input type='checkbox' name='vis' value='15.4.3'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='15.4.3'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">15.4.4 <a name='afsn15.4.4'></a>At gemme data i en javab&oslash;nne</H3>
<P CLASS="western">Vi skal nu skrive klassen, der har egenskaberne
hhv 'navnet' og 'besked'. Den ligger i pakken 'jsf' og kaldes Gaest:</P>
<PRE CLASS="kode-western">package jsf;

public class Gaest 
{
  String navnet;
  String besked;

  public String getNavnet()
  {
    return navnet;
  }

  public void setNavnet(String navnet)
  {
    this.navnet = navnet;
  }

  public String getBesked()
  {
    return besked;
  }

  public void setBesked(String besked)
  {
    this.besked = besked;
  }
}</PRE><P CLASS="western">
Bem&aelig;rk at de fleste udviklingsv&aelig;rkt&oslash;jer kan
generere get- og set-metoderne for os, s&aring;dan at vi slipper for
at spilde tid med at indtaste dem selv. Det er dog stadig et kedeligt
arbejde at generere og vedligeholde dem (senere, i <a href='kapitel15.jsp#afsn15.6.1'>afsnit 15.6.1</a>At gemme midlertidige data i en HashMap)
vil vi se et bud p&aring; hvordan man kan undg&aring; at skrive alt
for meget af denne slags 'hjerned&oslash;d' kode).</P>
<P CLASS="western">Til sidst kan vi nu binde klassen 'jsf.Gaest' til
navnet 'gaest' i  faces-config.xml:</P>
<PRE CLASS="kode-western">  &lt;managed-bean&gt;
    &lt;managed-bean-name&gt;<B>gaest</B>&lt;/managed-bean-name&gt;
    &lt;managed-bean-class&gt;<B>jsf.Gaest</B>&lt;/managed-bean-class&gt;
    &lt;managed-bean-scope&gt;<B>request</B>&lt;/managed-bean-scope&gt;
  &lt;/managed-bean&gt;</PRE><P CLASS="western">
Hermed er javab&oslash;nnen bundet og tilg&aelig;ngelig i
JSP-siderne.</P>
<H3 CLASS="western">15.4.5 <a name='afsn15.4.5'></a>Avanceret: Startv&aelig;rdier for
egenskaber</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel15.jsp#afsn15.4.5">
  <input type='checkbox' name='vis' value='15.4.5'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='15.4.5'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H2 CLASS="western">15.5 <a name='afsn15.5'></a>Afl&aelig;sning af JSF-b&oslash;nnes egenskab</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel15.jsp#afsn15.5">
  <input type='checkbox' name='vis' value='15.5'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='15.5'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">
15.5.1 <a name='afsn15.5.1'></a>Adgang til de implicitte objekter fra JSF</H3>
<P CLASS="western">Linjen</P>
<PRE CLASS="kode-western">      FacesContext fc = FacesContext.getCurrentInstance();</PRE><P CLASS="western">
er central. Den giver os adgang til hele JSF-systemet, der ligger som
et lag oven p&aring; JSP. 
</P>
<P CLASS="western">I dette eksempel er vi dog kun interesserede i det
underliggende JSP-system (JSF-systemets 'omgivelser' eller p&aring;
engelsk 'external context'), nemlig request-objektet attributter
(gaest-b&oslash;nnen er har virkefelt 'request'). Dem kan vi f&aring;
med</P>
<PRE CLASS="kode-western">      Gaest g = (Gaest) fc.getExternalContext().getRequestMap().get(&quot;gaest&quot;);</PRE><P CLASS="western">
 
</P>

<H4 CLASS="western">Adgang til request-objektet fra JSF</H4>
<P CLASS="western">Ville vi have fat i hele request-objektet skulle
vi skrive</P>
<PRE CLASS="kode-western">  FacesContext fc = FacesContext.getCurrentInstance();
  HttpServletRequest request;
  request = (HttpServletRequest) fc.getExternalContext().getRequest();</PRE><P CLASS="western">
Fordi JSF i princippet kan fungere oven p&aring; andre systemer end
Java Server Pages er returv&aelig;rdien af getRequest()-metoden af
type blot 'Object' og vi m&aring; selv konvertere den til et
HttpServletRequest-objekt.</P>
<P CLASS="western">Tilsvarende g&aelig;lder for de andre implicitte
objekter defineret implicit i JSP.</P>
<H4 CLASS="western">Adgang til session-objektet fra JSF</H4>
<P CLASS="western">Man kan f&aring; adgang til session-objektet med:</P>
<PRE CLASS="kode-western">  FacesContext fc = FacesContext.getCurrentInstance();
  HttpSession session = (HttpSession) fc.getExternalContext().getSession(false);</PRE><P CLASS="western">
Kaldet til getSession(false) giver sessionobjektet hvis <SPAN STYLE="font-style: normal">det
allerede er oprettet, ellers null. &Oslash;nsker man at
sessionobjektet skal oprettes hvis det ikke allerede findes skal man
skrive:</SPAN></P>
<PRE CLASS="kode-western">  HttpSession session = (HttpSession) fc.getExternalContext().getSession(true);</PRE><H4 CLASS="western">
Adgang til application-objektet fra JSF</H4>
<P CLASS="western">Man f&aring;r fat i application-objektet med</P>
<PRE CLASS="kode-western">  FacesContext fc = FacesContext.getCurrentInstance();
  ServletContext application; 
  application = (ServletContext) fc.getExternalContext().getContext();</PRE><P CLASS="western">
Bem&aelig;rk at</P>
<PRE CLASS="kode-western">  fc.getApplication()</PRE><P CLASS="western">
<I>ikke</I> giver det normale application-objekt man er vant til! xxx</P>

<H2 CLASS="western">15.6 <a name='afsn15.6'></a>JSF - anbefalet praksis</SPAN></H2>
<P CLASS="western">Jeg anbefaler at man binder forretningsdata, data
af lidt mere permanent karakter og data hvor noget lidt mere kompleks
programlogik er involveret til javab&oslash;nners egenskaber som
beskrevet ovenfor.</P>
<H3 CLASS="western">15.6.1 <a name='afsn15.6.1'></a>At gemme midlertidige data i en HashMap</H3>
<P CLASS="western">Til midlertidige formulardata, der bare nemt skal
opbevares et sted indtil de skal behandles eller gemmes et andet sted
(f.eks. i en database som Gaest-klassen ovenfor) synes jeg dog det
bliver for tungt at oprette og vedligeholde alle disse javab&oslash;nne.
I disse tilf&aelig;lde kan man bare bruge en HashMap (en
n&oslash;gleindekseret tabel, se <a href='kapitel15.jsp#afsn15.10'>afsnit 15.10</a>) til opbevaringen.</P>
<P CLASS="western">Herunder ses ovenst&aring;ende eksempel <I>uden</I><SPAN STYLE="font-style: normal">
brug af Gaest-klassen. I stedet bruges en HashMap</SPAN> (sammenlign
med tidligere erkl&aelig;ring af b&oslash;nnen 'gaest' i
faces-config.xml):</P>
<PRE CLASS="kode-western">  &lt;managed-bean&gt;
    &lt;managed-bean-name&gt;gaest&lt;/managed-bean-name&gt;
    &lt;managed-bean-class&gt;<B>java.util.HashMap</B>&lt;/managed-bean-class&gt;
    &lt;managed-bean-scope&gt;request&lt;/managed-bean-scope&gt;
  &lt;/managed-bean&gt;</PRE>
<P CLASS="western">Vi beh&oslash;ver ikke &aelig;ndre p&aring; selve
JSF-siden, da udtrykket</P>
<PRE CLASS="kode-western">&lt;h:inputText id=&quot;navn&quot; value=&quot;#{gaest.navn}&quot; /&gt;</PRE><P CLASS="western">
automatisk bliver opfattet anderledes af JSF hvis gaest er en
HashMap: I stedet for af forvente metoderne String getNavnet() og
void setNavnet(String navnet) kaldes nu metoderne get(&quot;navnet&quot;)
og set(&quot;navnet&quot;, navnet), dvs brugerens indtastning bliver
gemt under n&oslash;glen &quot;navnet&quot; i hashtabellen.</P>
<P CLASS="western">Her ses den endelige kode for Gaestebog (&aelig;ndringer
i forhold til tidligere versioner er i fed): 
</P>
<PRE CLASS="kode-western">package jsf;
import java.sql.*;
import java.util.HashMap;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;

public class Gaestebog
{
  private Connection con;
  
  public Gaestebog()
  {
    try {
      // Initialisering g&aelig;stebogen
      Class.forName(&quot;com.mysql.jdbc.Driver&quot;);
      con = DriverManager.getConnection(&quot;jdbc:mysql:///test&quot;);
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  public ResultSet getGaester()
  {
    System.out.println(&quot;getGaester()&quot;);

    try {
      // Udskriv g&aelig;stebogen
      Statement stmt = con.createStatement();
     ResultSet rs = stmt.executeQuery(&quot;SELECT navn, besked, dato FROM gaestebog&quot;);
      return rs;
    } catch (Exception e) {
      e.printStackTrace();
      return null;
    }
  }

  public String indskriv()
  {
    System.out.println(&quot;indskriv()&quot;);
    try {
      FacesContext fc = FacesContext.getCurrentInstance();
  
      System.out.println(&quot;fc=&quot;+fc);
      
<B>      HashMap g = (HashMap) fc.getExternalContext().getRequestMap().get(&quot;gaest&quot;);</B>
      System.out.println(&quot;formular=&quot;+g);
  
<B>      String navn = (String) g.get(&quot;navn&quot;);</B>
<B>      String besked = (String) g.get(&quot;besked&quot;);</B>
  
      PreparedStatement pstmt = con.prepareStatement(
        &quot;INSERT INTO gaestebog (navn, besked, dato, ip) VALUES(?,?,?,?)&quot;);

      pstmt.setString(1, navn);
      pstmt.setString(2, besked);
      pstmt.setDate(3, new java.sql.Date(System.currentTimeMillis()));
      
      HttpServletRequest request;
      request = (HttpServletRequest) (fc.getExternalContext().getRequest());
     
      pstmt.setString(4, request.getRemoteAddr());
      pstmt.executeUpdate();  
      pstmt.close();
      con.close();
  
      return &quot;tilbage&quot;;
    } catch (Exception e) {
      e.printStackTrace();
      return null;
    }
  }
}</PRE>
<H2 CLASS="western">15.7 <a name='afsn15.7'></a>Resum&eacute;</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel15.jsp#afsn15.7">
  <input type='checkbox' name='vis' value='15.7'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='15.7'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">15.7.1 <a name='afsn15.7.1'></a>JSF og JDeveloper</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel15.jsp#afsn15.7.1">
  <input type='checkbox' name='vis' value='15.7.1'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='15.7.1'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">15.7.2 <a name='afsn15.7.2'></a>M&aring;der at aktivere JSF-komponenter</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel15.jsp#afsn15.7.2">
  <input type='checkbox' name='vis' value='15.7.2'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='15.7.2'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  
<H2 CLASS="western">15.8 <a name='afsn15.8'></a>Kilder til JSF-komponenter</SPAN></H2>
<P CLASS="western">Som bekendt er JSF opdelt i en generel del
('core'), der ikke er specielt rettet mod HTML og en HTML-specifik
del, der indeholder de visuelle komponenter.</P>
<UL>
  <LI><P CLASS="western">Sun JSF RI (referenceimplementationen)</P>
  <LI><P CLASS="western">Oracle ADF Faces</P>
  <LI><P CLASS="western">Apache MyFaces</P>
</UL>

<H3 CLASS="western">15.8.1 <a name='afsn15.8.1'></a>Oracle ADF Faces</H3>
<P CLASS="western">Oracle ADF Faces (Application Development
Framework) er er Oracles egne webkomponenter skrevet om til JSF.  Det
er en en imponerende samling af omkring 100 komponenter, selvf&oslash;lgelig
indbefattet en r&aelig;kke der kan vise data fra en database.</P>
<P CLASS="western">L&aelig;s mere om ADF p&aring;
<A CLASS="western" HREF="http://www.oracle.com/technology/products/jdev/index.html">http://www.oracle.com/technology/products/jdev/index.html</A>
under 'Oracle ADF --&gt; Online tour'</P>
<H3 CLASS="western">15.8.2 <a name='afsn15.8.2'></a>Apache MyFaces</H3>
<P CLASS="western">Apache MyFaces er en samling JSF-komponenter med
&Aring;ben Kildekode (Open Source).</P>
<P CLASS="western">Se en r&aelig;kke eksempler p&aring;
MyFaces-komponenter <A CLASS="western" HREF="http://irian.at/myfaces" TARGET="_blank">her</A>
(klik p&aring; Examples og Components).Pr&oslash;v f.eks.
komponenterne File Upload, Calendar, HTML Editor og Tree.</P>
<P CLASS="western">Der er ca. 25 komponenter og validatorer. K&oslash;r
selv den nyeste udgave af <A CLASS="western" HREF="http://www.cv.ihk.dk/ITD/CN/WSP/jsf/myfaces-examples.war">eksemplerne</A>
(de findes ogs&aring; i en <A CLASS="western" HREF="http://www.cv.ihk.dk/ITD/CN/WSP/jsf/myfaces-simple.war">simplere</A>
udgave, der er lettere at forst&aring;) for at se alle komponenterne.</P>
<P CLASS="western">WAR-filen kan k&oslash;res direkte i Tomcat (smid
den i webapps/) eller fra JDeveloper (opret projekt fra WAR-fil). Du
starter eksemplerne ved at k&oslash;re 'index.jsp'.</P>
<H4 CLASS="western">Yderligere l&aelig;sning</H4>
<P CLASS="western">MyFaces' hjemmeside: <A CLASS="western" HREF="http://myfaces.org/">http://myfaces.org/</A>
(nyeste udgave er p&aring; <A CLASS="western" HREF="http://myfaces.apache.org/">http://myfaces.apache.org/</A>).</P>
<H4 CLASS="western">MyFaces med JDeveloper</H4>
<P CLASS="western">Som det fremg&aring;r af 
</P>
<P CLASS="western"><A CLASS="western" HREF="http://www.oracle.com/technology/products/jdev/101/howtos/myfaces/index.html">http://www.oracle.com/technology/products/jdev/101/howtos/myfaces/index.html</A>
kan man desv&aelig;rre ikke installere MyFaces i JDevelopers
komponentpalette i betaudgaven:</P>
<P CLASS="western">&rdquo;In the JDeveloper 10.1.3 Developer Preview
developers are restricted in that they cannot switch out the provided
JSF implementation with another implementation such as MyFaces. In
the production release of JDeveloper 10.1.3 developers will be able
to switch out the by default provided RI and use a JSF
implementations of their choice.&rdquo;</P>
<P CLASS="western">Man kan dog sagtens k&oslash;re og redigere
MyFaces-komponenter.</P>
<H3 CLASS="western">15.8.3 <a name='afsn15.8.3'></a>Andre kilder</H3>

<UL>
  <LI><P CLASS="western">Ourfaces - <A CLASS="western" HREF="https://ourfaces.dev.java.net/">https://ourfaces.dev.java.net</A>
  (&aring;ben kildekode): Tr&aelig;, Tabel, Kalender. Opfordring til
  flere bidrag</P>
  <LI><P CLASS="western">Chart FX for Java -
  <A CLASS="western" HREF="http://eu.softwarefx.com/SFXJavaProducts/CFXforJava/">http://eu.softwarefx.com/SFXJavaProducts/CFXforJava/</A>
  (lukket kildekode): Alle former for 2D- grafer</P>
  <LI><P CLASS="western">ILOG JViews Charts -
  <A CLASS="western" HREF="http://ilog.com/products/jviews/charts/">http://ilog.com/products/jviews/charts/</A>
  (lukket kildekode): Alle former for 2D- og 3D- grafer</P>
  <LI><P CLASS="western">Otrix - <A CLASS="western" HREF="http://otrix.com/products/">http://otrix.com/products/</A>
  (lukket kildekode): Menu, Tr&aelig;, Tabel</P>
  <LI><P CLASS="western">WebCharts 3D - <A CLASS="western" HREF="http://www.gpoint.com/">http://www.gpoint.com</A>
  (lukket kildekode): 2D- og 3D-datavisualiseringskomponenter</P>
  <LI><P CLASS="western">WebGalileo Faces Components -
  <A CLASS="western" HREF="http://jscape.com/webgalileofaces/">http://jscape.com/webgalileofaces/</A>
  (lukket kildekode): Tabbed Panel, Toolbar, Menu, Tree, Table, Pop-Up
  Dialog, HTML Editor, Calendar, Color Dialog, Calculator, Tree Table</P>
</UL>

<H2 CLASS="western">15.9 <a name='afsn15.9'></a>EL - Expression Language</SPAN></H2>
<P CLASS="western">V&aelig;rdier fra variabler og regneudtryk skal i
JSF puttes ind i et #{}-udtryk (i JSTL er det ${}), som er en m&aring;de
at g&oslash;re brug af EL - Expression Language. 
</P>
<P CLASS="western"><SPAN LANG="da-DK">EL er et elegant sprog, der g&oslash;r
det muligt, at skrive ret lange Java-udtryk p&aring; kort form</SPAN>.
</P>
<P CLASS="western">S&aring;ledes kan knudrede Java-udtryk, som
f.eks.:</P>
<PRE CLASS="kode-western">Velkommen &lt;%= ((Bruger)session.getAttribute(&quot;bruger&quot;)).getNavn() %&gt; !</PRE><P CLASS="western">
med EL skrives som blot (xxx tjek):</P>
<PRE CLASS="kode-western">Velkommen ${session.bruger.navn} !</PRE><P CLASS="western">
<SPAN LANG="da-DK">Det skyldes, at EL har en meget fleksibel
punktum-notation, der</SPAN> automatisk unders&oslash;ger egenskaber
p&aring; javab&oslash;nner og gennems&oslash;ger attributter p&aring;
implicitte objekter og andre n&oslash;gleindekserede objekter
(hashtabeller).</P>

<H2 CLASS="western">15.10 <a name='afsn15.10'></a>Om associative tabeller (HashMap)</SPAN></H2>
<P CLASS="western">Xxx r&aring;tekst fra andre b&oslash;ger - skal
kortes ned</P>
<P CLASS="western">En hashtabel er en tabel, der afbilder nogle
n&oslash;gler til v&aelig;rdier. Hashtabeller er nyttige som
associative afbildninger - n&aring;r man vil indeksere nogle objekter
ud fra f.eks. navne.</P>
<P CLASS="western">Man opretter en hashtabel med:</P>
<PRE CLASS="kode-western">  HashMap tabel = new HashMap();</PRE><P CLASS="western">
Derefter kan man l&aelig;gge en indgang i tabellen med <B>put</B>(
n&oslash;gle, v&aelig;rdi ). F.eks.:</P>
<PRE CLASS="kode-western">  <SPAN LANG="da-DK">tabel.put</SPAN>(&quot;abc&quot;, &quot;<SPAN LANG="da-DK">def</SPAN>&quot;);</PRE><P CLASS="western">
husker strengen &quot;def&quot; under n&oslash;glen &quot;abc&quot;.
Vil vi finde strengen frem igen, skal vi sl&aring; op under &quot;abc&quot;:</P>
<PRE CLASS="kode-western">  String v&aelig;rdi = (String) <SPAN LANG="da-DK">tabel.get</SPAN>(&quot;abc&quot;);</PRE>
<P CLASS="western">Da hashtabeller oftest anvendes til at lave
afbildninger med, bruger man i dagligdags sprogbrug mere ordet
'hashtabel' end ordet 'afbildning'.</P>


<P CLASS="western">F&oslash;r vi g&aring;r videre, s&aring; bem&aelig;rk
lige, at lister <SPAN STYLE="font-weight: medium"><I>g&aring;r fra
heltal til objekter</I><SPAN STYLE="font-style: normal">, dvs. man
finder listens elementer frem ud fra et helt tal (indekset). Blandt
andet har en liste metoderne:</SPAN></SPAN></P>
<P CLASS="klasseoversigt-western">void <B>add</B>( int indeks ,
element )<BR>Inds&aelig;tter <I>element</I><SPAN STYLE="font-style: normal">
i listen lige f&oslash;r plads nummer </SPAN><I>indeks</I>. F&oslash;rste
element er p&aring; plads nummer 0.</P>
<P CLASS="klasseoversigt-western"><SPAN STYLE="font-style: normal">Elementtype</SPAN>
<B>get</B>(int indeks)<BR>returnerer en reference til objektet p&aring;
plads nummer <I>indeks</I><SPAN STYLE="font-style: normal">. </SPAN>
</P>
<P CLASS="western">Man kan sige, at elementerne i en liste indekseres
(fremfindes) ud fra et <I>tal</I>.</P>
<P CLASS="western">Hashtabeller <SPAN STYLE="font-weight: medium"><I>g&aring;r
fra objekter til objekter</I><SPAN STYLE="font-style: normal"> p&aring;
den m&aring;de, at til hvert element knyttes et n&oslash;gle-objekt.
Elementerne kan derefter findes frem ud fra n&oslash;glerne.</SPAN></SPAN></P>
<P CLASS="western" STYLE="font-style: normal; font-weight: medium">Man
kan alts&aring; sige, at elementerne i en hashtabel indekseres
(fremfindes) ud fra et <I>objekt</I>.</P>
<P ALIGN=LEFT STYLE="margin-top: 0.21cm; margin-bottom: 0cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>java.util.HashMap
- n&oslash;gleindekseret tabel af objekter</I></FONT></P>
<P CLASS="klasseoversigt-western"><B>Konstrukt&oslash;rer</B></P>
<P CLASS="klasseoversigt-western">HashMap&lt;N&oslash;gletype,
Elementtype&gt; ()<BR>opretter en tom tabel hvor n&oslash;glerne er
af klassen <I>N&oslash;gletype</I> og v&aelig;rdierne af klassen
<I>Elementtype</I>. &lt;N&oslash;gletype, Elementtype&gt; kan
udelades.</P>
<P CLASS="klasseoversigt-western"><B>Metoder</B></P>
<P CLASS="klasseoversigt-western">void <B>put </B>(N&oslash;gletype
n&oslash;gle, Elementtype v&aelig;rdi)<BR>f&oslash;jer <SPAN STYLE="font-style: normal">objektet</SPAN>
<I>v&aelig;rdi</I><SPAN STYLE="font-style: normal"> til hashtabellen
under objektet </SPAN><I>n&oslash;gle</I><SPAN STYLE="font-style: normal">.</SPAN></P>
<P CLASS="klasseoversigt-western">Elementtype <B>get </B>(N&oslash;gletype
n&oslash;gle)<BR>sl&aring;r op under <I>n&oslash;gle</I><SPAN STYLE="font-style: normal">
og returnerer den v&aelig;rdi, der findes der (eller null hvis n&oslash;glen
ikke kendes).</SPAN></P>
<P CLASS="klasseoversigt-western">Elementtype <B>remove</B>(N&oslash;gletype
n&oslash;gle)<BR>fjerner indgangen under <I>n&oslash;gle</I><SPAN STYLE="font-style: normal">
og returnerer v&aelig;rdien (eller null hvis n&oslash;glen ikke
kendes).</SPAN></P>
<P CLASS="klasseoversigt-western">boolean <B>isEmpty</B>()<BR>returnerer
sand, hvis tabellen er tom (indeholder 0 indgange)<SPAN STYLE="font-style: normal">.</SPAN></P>
<P CLASS="klasseoversigt-western">int <B>size</B>()<BR>returnerer
antallet af indgange<SPAN STYLE="font-style: normal">.</SPAN></P>
<P CLASS="klasseoversigt-western">boolean <B>containsKey</B>(N&oslash;gletype
n&oslash;gle)<BR>returnerer sand, hvis <I>n&oslash;gle</I> <SPAN STYLE="font-style: normal">findes
blandt n&oslash;glerne i tabellen.</SPAN></P>
<P CLASS="klasseoversigt-western">boolean <B>containsValue</B>(Elementtype
v&aelig;rdi)<BR>returnerer sand, hvis <I>v&aelig;rdi</I> <SPAN STYLE="font-style: normal">findes
blandt v&aelig;rdierne i tabellen.</SPAN></P>
<P CLASS="klasseoversigt-western">Set&lt;N&oslash;gletype&gt;
<B>keySet</B><SPAN STYLE="font-weight: medium">()<BR>giver alle
n&oslash;glerne. Kan bruges til at genneml&oslash;be alle indgangene
(se nedenfor).</SPAN></P>
<P CLASS="klasseoversigt-western">String <B>toString</B> ()<BR>giver
tabellens indhold som en streng. Dette sker ved at konvertere hver af
indgangenes n&oslash;gler og v&aelig;rdier til strenge.</P>
<P CLASS="western">Herunder opretter vi en tabel, der holder styr p&aring;
f&oslash;dselsdatoer for et antal personer med deres fornavne som
n&oslash;gler, med put()-metoden: put(&quot;Jacob&quot;, dato).
Derefter kan indgangene hentes tilbage igen med get()-metoden:
get(&quot;Jacob&quot;) giver Jacobs f&oslash;dselsdato.</P>
<P CLASS="western">Sidst genneml&oslash;bes alle indgangene. Vi
bruger en for-l&oslash;kke til at l&oslash;be gennem tabellens n&oslash;gler
(med hashtabel.keySet()), hvorefter vi sl&aring;r de tilsvarende
v&aelig;rdier op<A CLASS="sdfootnoteanc" NAME="sdfootnote2anc" HREF="#sdfootnote2sym"><SUP>2</SUP></A>.</P>

<PRE CLASS="kode-western">import java.util.*;
public class BenytHashMap
{
  public static void main(String[] arg)
  {
    <I>// En tabel med strenge som n&oslash;gler og Date-objekter som v&aelig;rdier</I>
    HashMap&lt;String,Date&gt; <B>hashtabel = new HashMap&lt;String,Date&gt;()</B>;
    Date dato = new Date(71,0,1); <I>// 1. januar 1971</I>
    <B>hashtabel.put(&quot;Jacob&quot;,dato)</B>;
    <B>hashtabel.put(&quot;Troels&quot;,new Date(72,7,11))</B>; <I>// 11. august 1972</I>
    <B>hashtabel.put(&quot;Eva&quot;,new Date(73,2,5))</B>;
    <B>hashtabel.put(&quot;Ulla&quot;,new Date(69,1,9))</B>;
    System.out.println( &quot;tabel indeholder: &quot;+hashtabel );

<I>    // Lav nogle opslag i tabellen under forskellige navne</I>
    dato = <B>hashtabel.get(&quot;Troels&quot;)</B>;
    System.out.println( &quot;Opslag under 'Troels' giver: &quot;+dato);
    System.out.println( &quot;.. og under Jacob: &quot;+<B>hashtabel.get(&quot;Jacob&quot;)</B>);
    System.out.println( &quot;.. Kurtb&oslash;rge: &quot;+<B>hashtabel.get(&quot;Kurtb&oslash;rge&quot;)</B>);
    System.out.println( &quot;.. Eva: &quot;+<B>hashtabel.get(&quot;Eva&quot;)</B>);

<I>    // Genneml&oslash;b af alle elementer</I>
    <B>for (String n&oslash;gle : hashtabel.keySet()) {</B>
      <B>dato = hashtabel.get(n&oslash;gle)</B><SPAN STYLE="font-weight: medium">;</SPAN>
      System.out.println(n&oslash;gle + &quot;'s f&oslash;dsels&aring;r: &quot;+dato.getYear());
    }
    //JDK1.4: for (Iterator i = <SPAN STYLE="text-decoration: none">hashtabel.keySet</SPAN>().iterator(); i.hasNext();) {
      //JDK1.4: String n&oslash;gle = (String) i.next();
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">tabel indeholder: {Jacob=Fri Jan 01 00:00:00 CET 1971, Troels=Fri Aug 11 00:00:00 CET 1972, Eva=Mon Mar 05 00:00:00 CET 1973, Ulla=Sun Feb 09 00:00:00 CET 1969}
Opslag under 'Troels' giver: Fri Aug 11 00:00:00 CET 1972
.. og under Jacob: Fri Jan 01 00:00:00 CET 1971
.. Kurtb&oslash;rge: null
.. Eva: Mon Mar 05 00:00:00 CET 1973
Jacob's f&oslash;dsels&aring;r: 71
Troels's f&oslash;dsels&aring;r: 72
Eva's f&oslash;dsels&aring;r: 73
Ulla's f&oslash;dsels&aring;r: 69</PRE><P CLASS="western" STYLE="font-style: normal; font-weight: medium">
En hashtabel husker ikke r&aelig;kkef&oslash;lgen af indgangene.
Derfor er r&aelig;kkef&oslash;lgen, som elementerne bliver udskrevet
i, ikke den samme som den r&aelig;kkef&oslash;lge, de blev sat ind i.</P>
<P CLASS="western" STYLE="font-style: normal; font-weight: medium">Her
er en lille esperanto-dansk-ordbog. N&oslash;glerne er esperanto og
v&aelig;rdierne er danske ord:</P>
<PRE CLASS="kode-western">import java.util.*;
public class <SPAN LANG="da-DK">BenytHashMapOrdbog</SPAN>
{
  public static void main(String[] args)
  {
    HashMap&lt;String,String&gt; <B>ord = new HashMap&lt;String,String&gt;()</B>;
<B>    ord.put(&quot;granda&quot;, &quot;stor&quot;);</B>
<B>    ord.put(&quot;longa&quot;, &quot;lang&quot;);</B>
<B>    ord.put(&quot;bela&quot;, &quot;smukt&quot;);</B>
<B>    ord.put(&quot;estas&quot;, &quot;er&quot;)</B>;

    String esperantotekst = &quot;longa, granda hundo estas.... bela!&quot;;

    for (String eoOrd : esperantotekst.split(&quot;\\b&quot;)) { <I>// split efter ordgr&aelig;nser</I>
<SPAN STYLE="font-style: normal"><SPAN STYLE="font-weight: medium">      String </SPAN><B>da = ord.get( eoOrd )</B><SPAN STYLE="font-weight: medium">; </SPAN></SPAN><SPAN STYLE="font-weight: medium"><I>// sl&aring; esperantoord op og f&aring; det danske ord</I></SPAN>
      if (da == null) da=eoOrd;  <I>// hvis intet fundet lader vi det st&aring; uoversat</I>
      System.out.print( da );
    }
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">lang, stor hundo er.... smukt!</PRE><P CLASS="western" STYLE="font-style: normal; font-weight: medium">
Har vi en tekst p&aring; esperanto, kan vi nu overs&aelig;tte teksten
ord for ord til dansk. Hvert ord sl&aring;s op i hashtabellen og hvis
det findes, erstattes det med det danske ord. Tegn og ord, som ikke
kan findes i tabellen (s&aring;som &quot;hundo&quot;, der betyder
&quot;hund&quot;), efterlades uforandret.</P>



<DIV ID="sdfootnote1">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote1sym" HREF="#sdfootnote1anc">1</A>JSP
  med JSTL kan minde om sproget Coldfusion fra Macromedia/Allaire</P>
</DIV>
<DIV ID="sdfootnote2">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote2sym" HREF="#sdfootnote2anc">2</A>Bruger
  du JDK 1.4 eller tidligere skal du fjerne &lt;String,Date&gt; fra 
  new HashMap og bruge en iterator, som skitseret i kommentaren
  nederst. Iterator-objekter har to metoder: hasNext(), der fort&aelig;ller,
  om der er flere elementer og next(), der g&aring;r videre til n&aelig;ste
  element og returnerer det. 
  </P>
</DIV>

<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel14.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;n&aelig;ste &gt;&gt;&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_JSP.html'>om bogen</a>
<hr>
<font size=-2>http://javabog.dk/ - <b>Webprogrammering med Java Server Pages</b> af Jacob Nordfalk.
<br>
  Licens og kopiering under <a href='http://www.linuxbog.dk/licens.html'>&Aring;ben Dokumentlicens</a> (&Aring;DL)
  hvor intet andet er nvnt (72% af vrket).
</font>
<br>
nsker du at se de sidste 28% af dette vrk (275315 tegn)
skal du kbe bogen. S fr du pne figurer og layout, stikordsregister og en trykt bog med i kbet.
<!-- netlser: Wget/1.10, autoHent: true  -->
     

</body>
</html>
